/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.items;

import com.github.L_Ender.cataclysm.cataclysm;
import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.effect.Flame_Strike_Entity;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class The_Incinerator
extends Item {
    private final Multimap<Attribute, AttributeModifier> incineratorAttributes;

    public The_Incinerator(Item.Properties group) {
        super(group);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 13.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)-2.8f, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.ATTACK_RANGE.get()), (Object)new AttributeModifier(UUID.fromString("0CB612AF-CE7C-4FD2-9647-4BFD75B8D8A0"), "Tool modifier", 2.0, AttributeModifier.Operation.ADDITION));
        this.incineratorAttributes = builder.build();
    }

    public UseAnim m_6164_(ItemStack p_77661_1_) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack p_77626_1_) {
        return 72000;
    }

    public void m_5551_(ItemStack p_43394_, Level p_43395_, LivingEntity p_43396_, int p_43397_) {
        if (p_43396_ instanceof Player) {
            Player player = (Player)p_43396_;
            int i = this.m_8105_(p_43394_) - p_43397_;
            double headY = player.m_20186_() + 1.0;
            int standingOnY = Mth.m_14107_((double)player.m_20186_()) - 2;
            float yawRadians = (float)Math.toRadians(90.0f + player.m_146908_());
            boolean hasSucceeded = false;
            if (i >= 60) {
                for (int l = 0; l < 10; ++l) {
                    double d2 = 2.25 * (double)(l + 1);
                    int j2 = (int)(1.5f * (float)l);
                    if (!this.spawnFlameStrike(player.m_20185_() + (double)Mth.m_14089_((float)yawRadians) * d2, player.m_20189_() + (double)Mth.m_14031_((float)yawRadians) * d2, standingOnY, headY, yawRadians, 40, j2, j2, p_43395_, 1.0f, player)) continue;
                    hasSucceeded = true;
                }
                if (hasSucceeded) {
                    if (!p_43395_.f_46443_) {
                        player.m_36335_().m_41524_((Item)this, CMConfig.TheIncineratorCooldown);
                    }
                    ScreenShake_Entity.ScreenShake(p_43395_, player.m_20182_(), 30.0f, 0.15f, 0, 30);
                    player.m_5496_((SoundEvent)ModSounds.SWORD_STOMP.get(), 1.0f, 1.0f);
                }
            }
        }
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        int i = this.m_8105_(stack) - count;
        if (i == 60) {
            player.m_5496_((SoundEvent)ModSounds.FLAME_BURST.get(), 1.0f, 1.0f);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
        }
        return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int m_6473_() {
        return 16;
    }

    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public float m_8102_(ItemStack p_43288_, BlockState p_43289_) {
        if (p_43289_.m_60713_(Blocks.f_50033_)) {
            return 40.0f;
        }
        Material material = p_43289_.m_60767_();
        return material != Material.f_76300_ && material != Material.f_76302_ && !p_43289_.m_204336_(BlockTags.f_13035_) && material != Material.f_76285_ ? 1.0f : 1.5f;
    }

    public boolean m_8096_(BlockState p_43298_) {
        return p_43298_.m_60713_(Blocks.f_50033_);
    }

    private boolean spawnFlameStrike(double x, double z, double minY, double maxY, float rotation, int duration, int wait, int delay, Level world, float radius, Player player) {
        BlockPos blockpos = new BlockPos(x, maxY, z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = world.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)world, blockpos1, Direction.UP)) continue;
            if (!world.m_46859_(blockpos) && !(voxelshape = (blockstate1 = world.m_8055_(blockpos)).m_60812_((BlockGetter)world, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((double)(blockpos = blockpos.m_7495_()).m_123342_() >= minY);
        if (flag) {
            world.m_7967_((Entity)new Flame_Strike_Entity(world, x, (double)blockpos.m_123342_() + d0, z, rotation, duration, wait, delay, radius, false, (LivingEntity)player));
            return true;
        }
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.f_44672_ != EnchantmentCategory.BREAKABLE && enchantment.f_44672_ == EnchantmentCategory.WEAPON;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.incineratorAttributes : super.m_7167_(equipmentSlot);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)cataclysm.PROXY.getISTERProperties());
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"item.cataclysm.incinerator.desc").m_130940_(ChatFormatting.DARK_GREEN));
        tooltip.add((Component)Component.m_237115_((String)"item.cataclysm.incinerator2.desc").m_130940_(ChatFormatting.DARK_GREEN));
        tooltip.add((Component)Component.m_237115_((String)"item.cataclysm.incinerator3.desc").m_130940_(ChatFormatting.DARK_GREEN));
    }
}

